<?php
require_once __DIR__ . '/razorpay-php-2.9.0/razorpay-php-2.9.0/Razorpay.php';

use Razorpay\Api\Api;

$requestData = json_decode(file_get_contents('php://input'), true);


if (!$requestData) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid data received.']);
    exit;
}
// Razorpay API credentials
$apiKey = 'rzp_live_dI3XMBzBciMA3c';
$apiSecret = 'z9kFm0YhahdmX6Hh28xsOsV0';
$api = new Api($apiKey, $apiSecret);

// Fetch the total amount from POST data (sent by frontend)
$totalAmount = isset( $requestData['totalAmount'] ) ?  $requestData['totalAmount'] * 100 : '' ;  

// Prepare order details
$orderData = [
    'amount' => $totalAmount, // Amount in subunits
    'currency' => 'INR',
    'payment_capture' => 1,  // Auto capture payment
];

try {
    // Create the order with Razorpay
    $razorpayOrder = $api->order->create($orderData);

    // Return success response with order ID
    echo json_encode([
        'success' => true,
        'order_id' => $razorpayOrder['id'],
        'totalamount' => $totalAmount
    ]);
} catch (Exception $e) {
    // Handle errors
    echo json_encode([
        'success' => false,
        'message' => 'Could not create Razorpay order. Error: ' . $e->getMessage()
    ]);
}

?>
